### 32.4. 混合XA和non-XA的JMS连接

当使用JTA时，主要的JMS ConnectionFactory bean将是XA　aware，并参与到分布式事务中。有些情况下，你可能需要使用non-XA的ConnectionFactory去处理一些JMS消息。例如，你的JMS处理逻辑可能比XA超时时间长。

如果想使用一个non-XA的ConnectionFactory，你可以注入nonXaJmsConnectionFactory　bean而不是@Primary jmsConnectionFactory　bean。为了保持一致，jmsConnectionFactory　bean将以别名xaJmsConnectionFactor来被使用。

示例如下：
```java
// Inject the primary (XA aware) ConnectionFactory
@Autowired
private ConnectionFactory defaultConnectionFactory;
// Inject the XA aware ConnectionFactory (uses the alias and injects the same as above)
@Autowired
@Qualifier("xaJmsConnectionFactory")
private ConnectionFactory xaConnectionFactory;
// Inject the non-XA aware ConnectionFactory
@Autowired
@Qualifier("nonXaJmsConnectionFactory")
private ConnectionFactory nonXaConnectionFactory;
```
